% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textMetadata.R
\name{textMetadata,KorAPConnection-method}
\alias{textMetadata,KorAPConnection-method}
\alias{textMetadata}
\title{Retrieve metadata for a text, identified by its sigle (id)}
\usage{
\S4method{textMetadata}{KorAPConnection}(kco, textSigle, verbose = kco@verbose)
}
\arguments{
\item{kco}{\code{\link[=KorAPConnection]{KorAPConnection()}} object (obtained e.g. from \code{KorAPConnection()})}

\item{textSigle}{unique text id (concatenation of corpus, document and text ids, separated by \code{/}, e.g. ) or vector thereof}

\item{verbose}{logical. If \code{TRUE}, additional diagnostics are printed. Defaults to \code{kco@verbose}.}
}
\value{
Tibble with columns for each metadata property. In case of errors, such as non-existing texts/sigles, the tibble will also contain a column called \code{errors}.
If there are metadata columns you cannot make sense of, please ignore them. The function simply returns all the metadata it gets from the server.
}
\description{
Retrieves metadata for a text, identified by its sigle (id) using the corresponding KorAP API
(see \href{https://github.com/KorAP/Kustvakt/wiki/Service:-Metadata-Retrieval}{Kustvakt Wiki}).
To retrieve the metadata for every text in a virtual corpus, use \code{\link[=corpusQuery]{corpusQuery()}}
with \verb{<base/s=t>} as query, instead.
}
\examples{
\dontrun{
KorAPConnection() |> textMetadata(c("WUD17/A97/08542", "WUD17/B96/57558", "WUD17/A97/08541"))
}

}
