% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateSSLData.R
\name{generate2ClassGaussian}
\alias{generate2ClassGaussian}
\title{Generate data from 2 Gaussian distributed classes}
\usage{
generate2ClassGaussian(n = 10000, d = 100, var = 1, expected = TRUE)
}
\arguments{
\item{n}{integer; Number of examples to generate}

\item{d}{integer; dimensionality of the problem}

\item{var}{numeric; size of the variance parameter}

\item{expected}{logical; whether the decision boundary should be the expected or perpendicular}
}
\description{
Generate data from 2 Gaussian distributed classes
}
\examples{
data <- generate2ClassGaussian(n=1000,d=2,expected=FALSE)
plot(data[,1],data[,2],col=data$Class,asp=1)
}
\seealso{
Other RSSL datasets: 
\code{\link{generateABA}()},
\code{\link{generateCrescentMoon}()},
\code{\link{generateFourClusters}()},
\code{\link{generateParallelPlanes}()},
\code{\link{generateSlicedCookie}()},
\code{\link{generateSpirals}()},
\code{\link{generateTwoCircles}()}
}
\concept{RSSL datasets}
