% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ISOPROJ.R
\name{do.isoproj}
\alias{do.isoproj}
\title{Isometric Projection}
\usage{
do.isoproj(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix of projected observations as rows.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are loadings.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Isometric Projection is a linear dimensionality reduction algorithm that exploits
geodesic distance in original data dimension and mimicks the behavior in the target dimension.
Embedded manifold is approximated by graph construction as of ISOMAP. Since it involves
singular value decomposition and guesses intrinsic dimension by the number of positive singular values
from the decomposition of data matrix, it automatically corrects the target dimension accordingly.
}
\examples{
## use iris dataset
data(iris)
set.seed(100)
subid <- sample(1:150, 50)
X     <- as.matrix(iris[subid,1:4])
lab   <- as.factor(iris[subid,5])

## try different connectivity levels
output1 <- do.isoproj(X,ndim=2,type=c("proportion",0.50))
output2 <- do.isoproj(X,ndim=2,type=c("proportion",0.70))
output3 <- do.isoproj(X,ndim=2,type=c("proportion",0.90))

## visualize two different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="50\%", col=lab, pch=19)
plot(output2$Y, main="70\%", col=lab, pch=19)
plot(output3$Y, main="90\%", col=lab, pch=19)
par(opar)

}
\references{
\insertRef{cai_isometric_2007}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
