% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_cf.R, R/surv_effect.R,
%   R/treatment_effect.R
\name{confint}
\alias{confint}
\alias{confint.prediction_cf}
\alias{confint.surv_effect}
\alias{confint.treatment_effect}
\title{Confidence Interval}
\usage{
\method{confint}{prediction_cf}(object, parm, level = 0.95, include_se = FALSE, ...)

\method{confint}{surv_effect}(object, parm, level = 0.95, transform, ...)

\method{confint}{treatment_effect}(object, parm, level = 0.95, transform, ...)
}
\arguments{
\item{object}{Object to construct confidence interval.}

\item{parm}{(\code{character} or \code{integer}) Names of the parameters to construct confidence interval.}

\item{level}{(\code{numeric}) Confidence level.}

\item{include_se}{(\code{flag}) Whether to include the standard error as a column in the result matrix.}

\item{...}{Not used.}

\item{transform}{(\code{function}) Transform function.}
}
\value{
A \code{matrix} of the confidence interval.
}
\description{
Obtain the confidence interval for the marginal mean or the contrast.
}
\examples{
robin_res <- robin_glm(
  y_b ~ treatment * s1,
  data = glm_data, treatment = treatment ~ s1, contrast = "log_risk_ratio"
)
confint(robin_res$marginal_mean, level = 0.7)
confint(robin_res$contrast, parm = 1:3, level = 0.9)
}
