% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_waffle_chart.R
\name{create_waffle_chart}
\alias{create_waffle_chart}
\title{create_waffle_chart}
\usage{
create_waffle_chart(
  x = NULL,
  name_col = NULL,
  prop_col = NULL,
  title = NULL,
  select_fill = "brown",
  default_fill = "lightgray"
)
}
\arguments{
\item{x}{Either a dataframe or a vector of named integer proportions.}

\item{name_col}{If 'x' is a dataframe, a required string setting the column name having the variable names.}

\item{prop_col}{If 'x' is a dataframe, a required string setting the column name having the variable proportions.}

\item{title}{A string that sets the main title for the chart.}

\item{select_fill}{A string that sets the fill color for tiles with proportion values.}

\item{default_fill}{A string that sets the fill color for tiles without proportion values.}
}
\value{
A ggplot2 class object
}
\description{
Function creates a "waffle" chart that displays percentages for multiple variables.
The chart is similar to a heatmap with a 10 by 10 array of tiles (each representing one percent) that
are colored to the extent of the variable's proportion value.
For more information on "waffle" charts see \href{https://baryon.be/uncommon-chart-types-waffle-charts/}{What is a waffle chart}.
}
\examples{
library(grid)
library(gtable)
library(ggplotify)
library(ggplot2)
library(RplotterPkg)

proportions_v <- c(
var1=10,var2=40,var3=20, var4=50, var5=5,
var6=30, var7=10, var8=67, var9=42, var10=33,
var11=7, var12=35,var13=22, var14=90
)
create_waffle_chart(
  x = proportions_v,
  title = "Test For 14 Proportion Variables"
)

}
