% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genField.R
\name{changeRegion}
\alias{changeRegion}
\title{Change Region}
\usage{
changeRegion(n, s, type = 1L, middle, delta = 0.15, distFun = dist)
}
\arguments{
\item{n}{dimensions of the random field. Numeric vector.}

\item{s}{parameter for the size of the blocks, 0.5 < s < 1, block length \eqn{l_n = [n^s]}.}

\item{type}{change region type (integer or character). See "Details".}

\item{middle, delta, distFun}{parameters for type 4L. See "Details".}
}
\value{
\item{Types 1a, 1b, 1c, 2, 4, 5}{A vector of indices.}
\item{Type 3}{A numeric (n x n) matrix containing the heights of the shifts at the corresponding locations.}
}
\description{
Generates the indices for different types of change regions.
}
\details{
Change region types:
\itemize{
\item 1L or "1a": exactly one block is shifted
\item "1b": size of the shift region is one block, but the shift region lies in two blocks
\item "1c": size of the shift region is one block, but the shift region lies in four blocks
\item 2L: exactly half of the data is shifted
\item 3L: there is a steady increase from left to right
\item 4L:
\item 5L: for demonstration purposes: the field is divided into 10 "columns". Every other column is shifted
\item 6L:
\item 7L: a "circle" including everything within \code{distFun} \code{delta} from \code{middle} is shifted
}
}
\examples{
changeRegion(c(50, 50), 0.6, "1a")
changeRegion(c(50, 50), type = 2)
changeRegion(c(50, 50), type = 3L)
changeRegion(c(50, 50), type = 7L, middle = c(10, 10))

}
\seealso{
\link{genField}
}
