% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SDTree}
\alias{plot.SDTree}
\title{Plot SDTree}
\usage{
\method{plot}{SDTree}(x, ...)
}
\arguments{
\item{x}{Fitted object of class \code{SDTree}.}

\item{...}{Further arguments for DiagrammeR::render_graph()}
}
\value{
graph object from DiagrammeR::render_graph()
}
\description{
Plot the SDTree.
}
\seealso{
\code{\link{SDTree}}
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
plot(model)
}
\author{
Markus Ulmer
}
