% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blmpSDPD.R
\name{blmpSDPD}
\alias{blmpSDPD}
\title{Bayesian log-marginal posterior probabilities for spatial panel models}
\usage{
blmpSDPD(
  formula,
  data,
  W,
  index,
  model = list("ols", "slx", "sar", "sdm", "sem", "sdem"),
  effect = "individual",
  ldet = NULL,
  lndetspec = list(m = NULL, p = NULL, sd = NULL),
  dynamic = FALSE,
  tlaginfo = list(ind = NULL),
  LYtrans = FALSE,
  incr = NULL,
  rintrv = TRUE,
  prior = "uniform",
  bprarg = 1.01
)
}
\arguments{
\item{formula}{a symbolic description for the model to be estimated}

\item{data}{a data.frame}

\item{W}{spatial weights matrix (row-normalized)}

\item{index}{the indexes (names of the variables for the spatial and time component)}

\item{model}{a list of models for which the Bayesian log-marginal posterior probabilities need to be calculated, list("ols","slx","sar","sdm","sem","sdem")}

\item{effect}{type of fixed effects, c("none","individual","time","twoways"), default ="individual"}

\item{ldet}{Type of computation of log-determinant, c("full","mc"). Default "full" for smaller problems, "mc" for large problems.}

\item{lndetspec}{specifications for the calculation of the log-determinant}

\item{dynamic}{logical, if TRUE time lag of the dependent variable is included. Default = FALSE}

\item{tlaginfo}{specification for the time lag, default = list(ind=NULL), \emph{ind} - i-th column in the data frame which represents the time lag}

\item{LYtrans}{logical, default FALSE. If Lee-Yu transformation should be used for demeaning of the variables}

\item{incr}{increment for vector of values for rho}

\item{rintrv}{logical, default TRUE, calculates eigenvalues of W. If FALSE, the interval for rho is (-1,1).}

\item{prior}{type of prior to be used c("uniform","beta"). Default "uniform"}

\item{bprarg}{argument for the beta prior. Default = 1.01}
}
\value{
A list
\item{lmarginal}{log-marginal posterior}
\item{probs}{model probability}
}
\description{
Calculates log-marginal posterior probabilities for model comparison purposes.
}
\details{
For the Spatial Durbin Error Model (SDEM) the marginal distribution is:
\deqn{p(\lambda|y) = \frac{1}{p(y)} p(\lambda) \Gamma(a) (2\pi)^{-a} \frac{|P|^{T-1}}{|Z'Z|^{1/2}} (e'e)^{-a}}
For the Spatial Durbin Model (SDM) the marginal distribution is:
\deqn{p(\rho|y) = \frac{1}{p(y)} p(\rho) \Gamma(a) (2\pi)^{-a} \frac{|P|}{|Z'Z|^{1/2}} (e'e)^{-a}}
where \eqn{p(\lambda)} is prior on \eqn{\lambda} and \eqn{p(\rho)} is prior on \eqn{\rho},
either uniform \eqn{\frac{1}{D}}, \eqn{D = 1/\omega_{max}-1/\omega_{min}} or beta prior;
No priors on beta and sige;
\eqn{\omega_{max}} and \eqn{\omega_{min}} are the maximum and minimum eigenvalues of
\emph{W} - spatial weights matrix;
\eqn{Z = X} for lag or error model and \eqn{Z = [X WX]} for Durbin model;
X - matrix of \eqn{k} covariates.

For more details, see LeSage (2014).

Based on MatLab function log_marginal_panelprob.m.

In \emph{tlaginfo = list(ind = NULL)}:

\emph{ind} i-th column in \emph{data} which represents the time lag,
if not specified then the lag from the dependent variable is created and the
panel is reduced from n\emph{t to n}(t-1)
}
\examples{
\donttest{
## US States Production data
data(Produc, package = "plm")
## Spatial weights row-normalized matrix of 48 US states
data(usaww, package = "splm")
isrownor(usaww)
form1 <- log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp
res1  <- blmpSDPD(formula = form1, data=Produc, W = usaww,
                 index = c("state","year"),
                 model = list("sar","sdm","sem","sdem"),
                 effect = "twoways")
res1
res2  <- blmpSDPD(formula = form1, data = Produc, W = usaww,
                 index = c("state","year"),
                 model = list("sar","sdm","sem","sdem"),
                 effect = "twoways", dynamic = TRUE)
res2}

}
\references{
LeSage, J. P., & Parent, O. (2007). Bayesian model averaging for spatial econometric models. \emph{Geographical Analysis, 39(3)}, 241-267.

LeSage, J. P. (2014). Spatial econometric panel data model specification: A Bayesian approach. \emph{Spatial Statistics, 9}, 122-145.
}
\author{
Rozeta Simonovska
}
