% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance.R
\name{deviance.SSN2}
\alias{deviance.SSN2}
\alias{deviance.ssn_lm}
\alias{deviance.ssn_glm}
\title{Fitted model deviance}
\usage{
\method{deviance}{ssn_lm}(object, ...)

\method{deviance}{ssn_glm}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The deviance.
}
\description{
Returns the deviance of a fitted model object.
}
\details{
The deviance is twice the difference in log-likelihoods between the
saturated (perfect-fit) model and the fitted model.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_glm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  family = "Gamma",
  tailup_type = "exponential",
  additive = "afvArea"
)
deviance(ssn_mod)
}
