% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createFitSccsModelArgs}
\alias{createFitSccsModelArgs}
\title{Create a parameter object for the function fitSccsModel}
\usage{
createFitSccsModelArgs(
  prior = createPrior("laplace", useCrossValidation = TRUE),
  control = createControl(cvType = "auto", selectorType = "byPid", startingVariance =
    0.1, seed = 1, resetCoefficients = TRUE, noiseLevel = "quiet"),
  profileGrid = NULL,
  profileBounds = c(log(0.1), log(10))
)
}
\arguments{
\item{prior}{The prior used to fit the model. See Cyclops::createPrior for details.}

\item{control}{The control object used to control the cross-validation used to determine the hyperparameters of the prior (if applicable). See Cyclops::createControl for details.}

\item{profileGrid}{A one-dimensional grid of points on the log(relative risk) scale where the likelihood for coefficient of variables is sampled. See details.}

\item{profileBounds}{The bounds (on the log relative risk scale) for the adaptive sampling of the likelihood function.}
}
\value{
An object of type \code{FitSccsModelArgs}.
}
\description{
Create a parameter object for the function fitSccsModel
}
\details{
Create an object defining the parameter values.

Likelihood profiling is only done for variables for which \code{profileLikelihood} is set to \code{TRUE} when
calling \code{\link[=createEraCovariateSettings]{createEraCovariateSettings()}}. Either specify the \code{profileGrid} for a completely user-
defined grid, or \code{profileBounds} for an adaptive grid. Both should be defined on the log IRR scale.
When both \code{profileGrid} and \code{profileGrid} are \code{NULL} likelihood profiling is disabled.

To make use of the more efficient Hermite interpolation in evidence synthesis, set
\code{profileGrid = seq(log(0.1), log(10), length.out = 8)} and \code{profileBounds = NULL}.
}
