% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/utilities.R
\name{PseudobulkExpression}
\alias{PseudobulkExpression}
\alias{PseudobulkExpression.Assay}
\alias{PseudobulkExpression.StdAssay}
\alias{PseudobulkExpression.Seurat}
\title{Pseudobulk Expression}
\usage{
PseudobulkExpression(object, ...)

\method{PseudobulkExpression}{Assay}(
  object,
  assay,
  category.matrix,
  features = NULL,
  layer = "data",
  slot = deprecated(),
  verbose = TRUE,
  ...
)

\method{PseudobulkExpression}{StdAssay}(
  object,
  assay,
  category.matrix,
  features = NULL,
  layer = "data",
  slot = deprecated(),
  verbose = TRUE,
  ...
)

\method{PseudobulkExpression}{Seurat}(
  object,
  assays = NULL,
  features = NULL,
  return.seurat = FALSE,
  group.by = "ident",
  add.ident = NULL,
  layer = "data",
  slot = deprecated(),
  method = "average",
  normalization.method = "LogNormalize",
  scale.factor = 10000,
  margin = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{...}{Arguments to be passed to methods such as \code{\link{CreateSeuratObject}}}

\item{assay}{The name of the passed assay - used primarily for warning/error messages}

\item{category.matrix}{A matrix defining groupings for pseudobulk expression
calculations; each column represents an identity class, and each row a sample}

\item{features}{Features to analyze. Default is all features in the assay}

\item{layer}{Layer(s) to user; if multiple are given, assumed to follow
the order of 'assays' (if specified) or object's assays}

\item{slot}{(Deprecated) See \code{layer}}

\item{verbose}{Print messages and show progress bar}

\item{assays}{Which assays to use. Default is all assays}

\item{return.seurat}{Whether to return the data as a Seurat object. Default is FALSE}

\item{group.by}{Categories for grouping (e.g, "ident", "replicate",
"celltype"); "ident" by default}

\item{add.ident}{(Deprecated) See group.by}

\item{method}{The method used for calculating pseudobulk expression; one of:
"average" or "aggregate"}

\item{normalization.method}{Method for normalization, see \code{\link{NormalizeData}}}

\item{scale.factor}{Scale factor for normalization, see \code{\link{NormalizeData}}}

\item{margin}{Margin to perform CLR normalization, see \code{\link{NormalizeData}}}
}
\value{
Returns object after normalization

Returns a matrix with genes as rows, identity classes as columns.
If return.seurat is TRUE, returns an object of class \code{\link{Seurat}}.
}
\description{
Normalize the count data present in a given assay.

Returns a representative expression value for each identity class
}
\concept{utilities}
