% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{MERSKorea2015_list}
\alias{MERSKorea2015_list}
\title{Middle East respiratory syndrome in South Korea, 2015}
\format{
A list of 2 elements:
\describe{
  \item{linelist}{A data frame with 162 observations and 15 variables:
    \describe{
      \item{id}{Case identifier (character)}
      \item{age}{Age of the individual (integer)}
      \item{age_class}{Age class of the individual (character)}
      \item{sex}{Sex of the individual (factor with 2 levels)}
      \item{place_infect}{Place of infection (factor with 2 levels)}
      \item{reporting_ctry}{Reporting country (factor with 2 levels)}
      \item{loc_hosp}{Location or hospital (factor with 13 levels)}
      \item{dt_onset}{Date of symptom onset (Date)}
      \item{dt_report}{Date of case report (Date)}
      \item{week_report}{Week of report (factor with 5 levels)}
      \item{dt_start_exp}{Start date of exposure (Date)}
      \item{dt_end_exp}{End date of exposure (Date)}
      \item{dt_diag}{Date of diagnosis (Date)}
      \item{outcome}{Outcome of the case (factor with 2 levels)}
      \item{dt_death}{Date of death, if applicable (Date)}
    }
  }
  \item{contacts}{A data frame with 98 observations and 4 variables:
    \describe{
      \item{from}{ID of the source case (character)}
      \item{to}{ID of the contact case (character)}
      \item{exposure}{Type of exposure (factor with 5 levels)}
      \item{diff_dt_onset}{Difference in days between onset dates (integer)}
    }
  }
}
}
\source{
Data taken from the \pkg{outbreaks} package version 1.9.0
}
\usage{
data(MERSKorea2015_list)
}
\description{
This dataset, MERSKorea2015_list, is a list containing two data frames with information
collected during the first weeks of the Middle East respiratory syndrome (MERS-CoV) outbreak
in South Korea in 2015. The data was initially gathered by the Epidemic Intelligence group at
the European Centre for Disease Prevention and Control (ECDC).
}
\details{
The dataset name has been kept as 'MERSKorea2015_list' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
SouthKoreAPIs package and assists users in identifying its specific characteristics.
The suffix 'list' indicates that the object is a list containing multiple related data frames.
The original content has not been modified in any way.
}
