% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{simulate_cdf}
\alias{simulate_cdf}
\title{Inverse Tranform Sampling}
\usage{
simulate_cdf(n, cdf, range = c(-1e+200, 1e+200), ...)
}
\arguments{
\item{n}{number of observations.}

\item{cdf}{cumulative distribution function to be sampled from.}

\item{range}{support of the given \code{cdf}.}

\item{...}{other arguments/parameters to be passed onto \code{cdf}.}
}
\description{
Generates sample numbers at random from any probability distribution
given its cumulative distribution function. Pre-defined distribution
functions such as \code{pnorm} are supported. \cr \cr
See \href{https://en.wikipedia.org/wiki/Inverse_transform_sampling}{here}
for the algorithm.
}
\examples{
simulate_cdf(10, pnorm)
simulate_cdf(10, pbeta, shape1 = 2, shape2 = 2)
}
