% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichCirclize.R
\name{drawLegends}
\alias{drawLegends}
\title{Draw Dual-Sided Legends on a Plot}
\usage{
drawLegends(
  labels,
  colors,
  legend_width,
  x_positions,
  y_position,
  just_positions,
  text_alignments,
  font_size
)
}
\arguments{
\item{labels}{Vector of labels for the legends.}

\item{colors}{Vector of colors corresponding to the labels.}

\item{legend_width}{The width of each legend viewport expressed in grid units.}

\item{x_positions}{Numeric vector of length 2 specifying the x-positions of the left and right legends.}

\item{y_position}{The y-position common for both legends, expressed as a fraction of the plot height.}

\item{just_positions}{List of two vectors, each specifying the horizontal and vertical justification for the legends.}

\item{text_alignments}{List of two character strings specifying text alignments for the legends ('left' or 'right').}

\item{font_size}{Numeric value specifying the font size for the legend labels.}
}
\value{
Invisible. This function is called for its side effects of drawing legends on a plot.
}
\description{
This function creates two sets of legends, one on the left and one on the right side of a plot.
It displays color-coded legends with labels corresponding to different data categories.
Each legend entry consists of a colored rectangle and a text label. The left side legend has
text aligned to the right of the color block, while the right side legend has text aligned
to the left of the color block.
}
\examples{
labels <- c("Label1", "Label2", "Label3", "Label4", "Label5", "Label6")
colors <- c("#ff0000", "#00ff00", "#0000ff", "#ffff00", "#ff00ff", "#00ffff")

# Convert to 'unit' objects for grid
grid::grid.roundrect(
  x = grid::unit(0.5, "npc"),  # "npc" stands for normalized parent coordinates
  y = grid::unit(0.5, "npc"),
  width = grid::unit(0.1, "npc"),
  height = grid::unit(0.05, "npc"),
  gp = grid::gpar(fill = "red"),
  r = grid::unit(0.1, "npc")  # rounding radius
)

# Example of drawing legends with specific labels and colors
drawLegends(labels, colors, grid::unit(2, "cm"), c(0.225, 0.75), 0.5,
            list(c("left", "center"), c("right", "center")),
            list("right", "left"), 10)

}
