% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichmentSpiralize.R
\name{enrichment_spiral_plots}
\alias{enrichment_spiral_plots}
\title{Create Spiral Plots with Legends Using 'spiralize' and 'ComplexHeatmap'}
\usage{
enrichment_spiral_plots(results)
}
\arguments{
\item{results}{A data frame containing 'Pathway', 'Sample', 'Value', 'PathwayColor', and 'SampleColor' columns.}
}
\value{
No return value, called for side effects. This function generates spiral plots and adds legends based on sample and pathway information.
}
\description{
This function initializes a spiral plot, adds tracks for pathways and samples,
and generates legends based on the sample and pathway information in the provided data frame.
It uses 'spiralize' for the spiral plot and 'ComplexHeatmap' for handling legends.
}
\examples{
# Example: Creating enrichment spiral plots with legends

# Define the results data frame
results <- data.frame(
  Pathway = c("Pathway1", "Pathway1", "Pathway2", "Pathway2", "Pathway3"),
  Sample = c("Sample1", "Sample1", "Sample2", "Sample2", "Sample3"),
  Value = c(20, 30, 15, 35, 25),
  PathwayColor = c("red", "red", "blue", "blue", "orange"),
  SampleColor = c("green", "green", "purple", "purple", "cyan"),
  stringsAsFactors = FALSE
)

# Create the enrichment spiral plots with legends
enrichment_spiral_plots(results)

}
