% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Endpoints.R
\docType{class}
\name{Endpoints}
\alias{Endpoints}
\title{Class of Endpoint}
\description{
Create a class of endpoint to specify its name, type and assign a random number
generator.
}
\examples{
# Instead of using Endpoint$new, please use endpoint(), a user-friendly
# wrapper. See examples in ?endpoint.

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Endpoints-new}{\code{Endpoints$new()}}
\item \href{#method-Endpoints-test_generator}{\code{Endpoints$test_generator()}}
\item \href{#method-Endpoints-get_generator}{\code{Endpoints$get_generator()}}
\item \href{#method-Endpoints-get_readout}{\code{Endpoints$get_readout()}}
\item \href{#method-Endpoints-get_uid}{\code{Endpoints$get_uid()}}
\item \href{#method-Endpoints-get_name}{\code{Endpoints$get_name()}}
\item \href{#method-Endpoints-get_type}{\code{Endpoints$get_type()}}
\item \href{#method-Endpoints-print}{\code{Endpoints$print()}}
\item \href{#method-Endpoints-clone}{\code{Endpoints$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-new"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-new}{}}}
\subsection{Method \code{new()}}{
initialize an endpoint
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$new(name, type = c("tte", "non-tte"), readout = NULL, generator, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{character vector. Name(s) of endpoint(s)}

\item{\code{type}}{character vector. Type(s) of endpoint(s). It supports
\code{"tte"} for time-to-event endpoints, and \code{"non-tte"} for
all other types of endpoints (e.g., continous, binary, categorical,
or repeated measurement. \code{TrialSimulator} will do some verification if
an endpoint is of type \code{"tte"}. However, no special
manipulation is done for non-tte endpoints.}

\item{\code{readout}}{numeric vector with name to be the non-tte endpoint(s).
\code{readout} should be specified for every non-tte endpoint. For
example, \code{c(endpoint1 = 6, endpoint2 = 3)}.  If all
endpoints are tte, \code{readout} can be \code{NULL}.}

\item{\code{generator}}{a RNG function. Its first argument must be `n`, number of
patients. It must return a data frame of `n` rows. It support all
built-in random number generators in \code{stats}, e.g., \code{stats::rnorm},
\code{stats::rexp}, etc. that with \code{n} as the argument for number of
observations. \code{generator} could be any custom functions as long as
(1) its first argument is \code{n}; and (2) it returns a vector of
length \code{n} or a data frame of \code{n} rows. Custom random number
generator can return data of more than one endpoint. This is useful
when users need to simulate correlated endpoints. The column names of
returned data frame should match to \code{name} exactly. If an endpoint
is of type \code{"tte"}, the custom \code{generator} should also return
a column as event indicator. For example, if \code{"pfs"} is \code{"tte"},
then custom \code{generator} should return at least two columns
\code{"pfs"} and \code{"pfs_event"}. Usually \code{pfs_event} can be
all 1s if no censoring. Censoring can be specified later when defining
the \code{Trial} through argument \code{dropout}. See \code{?Trial}.
Note that if covariates, e.g., biomarker, subgroup, are needed in
generating and analyzing trial data, they can be defined as
\code{Endpoint} as well.}

\item{\code{...}}{optional arguments for \code{generator}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-test_generator"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-test_generator}{}}}
\subsection{Method \code{test_generator()}}{
test random number generator of the endpoints. It returns an example
dataset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$test_generator(n = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{integer. Number of random numbers generated from the generator.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-get_generator"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-get_generator}{}}}
\subsection{Method \code{get_generator()}}{
return random number generator of an endpoint
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$get_generator()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-get_readout"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-get_readout}{}}}
\subsection{Method \code{get_readout()}}{
return readout function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$get_readout()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-get_uid"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-get_uid}{}}}
\subsection{Method \code{get_uid()}}{
return uid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$get_uid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-get_name"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-get_name}{}}}
\subsection{Method \code{get_name()}}{
return endpoints' name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$get_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-get_type"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-get_type}{}}}
\subsection{Method \code{get_type()}}{
return endpoints' type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$get_type()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-print"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-print}{}}}
\subsection{Method \code{print()}}{
print an endpoint object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$print(categorical_vars = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{categorical_vars}}{categorical_vars character. Vector of categorical variables. This can
be used to specify variables with limited distinct values as categorical
variables in summary.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Endpoints-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Endpoints-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Endpoints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
