% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grad_helpers.R
\name{AA}
\alias{AA}
\alias{BB}
\alias{AAfunc_Laplace_generic}
\alias{AAfunc_Gauss_generic}
\alias{BBfunc_Laplace_generic}
\alias{BBfunc_Gauss_generic}
\alias{getAAfunc_est_outer}
\alias{getBBfunc_est}
\alias{getBBfunc_est_outer}
\title{Helper functions for calculating gradient  of least-squares Shuffled Isotonic Regression criterion, for Laplace or for Gaussian errors}
\usage{
AA(yy, mm, func)

BB(mm, func)

AAfunc_Laplace_generic(dd, LL)

AAfunc_Gauss_generic(dd, sig)

BBfunc_Laplace_generic(dd, LL)

BBfunc_Gauss_generic(dd, sig)

getAAfunc_est_outer(eps, ww = 1/length(eps))

getBBfunc_est_outer(eps, ww = 1/length(eps))
}
\arguments{
\item{yy}{Y (response) observation vector (numeric).  Will apply
as.vector() so it may be a matrix or array with all dimensions trivial
except 1.}

\item{mm}{Current (unsorted) estimate/iterate at which to compute
gradient. (Length equals length of yy).  Will apply as.vector() so it
may be a matrix or array with all dimensions trivial except 1.}

\item{func}{This is a function; should be the actual "A" or "B" function
from the paper; AA and BB are just wrappers that call outer() with
func().  func() should accept vector or matrix arguments.}

\item{dd}{generic argument to the "A" function; usually of the form m - mmhat, where m is just some value of the regression function}

\item{LL}{Double Exponential "mean" parameter: corresponding density is $exp(-|d|/LL) / (2LL)$.}

\item{sig}{is standard deviation of the normal distribution.}

\item{eps}{is a vector of residuals (or estimated residuals).  In current
coding, it should have been preprocessed to be *unique*.  (If there
are repeats this should be encoded in ww).}

\item{ww}{is vector of weights of same length as eps, and summing to 1.
Default is a weight of 1/length(eps) for each value of eps; if eps has
been pre-binned then ww is the weights from binning.}
}
\description{
Helper functions for calculating gradient  of least-squares Shuffled Isotonic Regression criterion, for Laplace or for Gaussian errors
}
\details{
See helper functions "A" and "B" in paper.

For getAAfunc_est:  returns a function(yy,mm) which is analogous to passing in an estimated 'func' argument to the AA function.  (Reason to not do it that way relates to making sure matrix arguments are handled correctly.)

getBBfunc_est returns a function which as of this coding *MUST*
    take only a numeric vector of length 1; longer vectors will not
    work. Be careful!  Note that ecdf objects are not intended to be
    stored permanently so storing functions returned by
    getBBfunc_est_outer or getAAfunc_est_outer may cause issues.
}
\examples{



 ## the "!!" de-quote (see ?partial) so e.g., can save mygradSIR for future runs.

####### gradient settings/setup for Gaussian


## set.seed(501)
library(distr)
mysig <- 1 ##  std dev
errdist <- Norm(0, sd=mysig)
mm0 <- function(xx){xx}
nn <- 300
xx <- sort(runif(n=nn, 0, 7))
yy <- mm0(xx) + errdist@r(nn)
## plot(xx,yy)

myScale <- mysig

AAfunc_Gauss <- purrr::partial(AAfunc_Gauss_generic, sig=!!mysig)
AA_Gauss <- purrr::partial(AA, func=!!AAfunc_Gauss)
BBfunc_Gauss <- purrr::partial(BBfunc_Gauss_generic, sig=!!mysig)
BB_Gauss <- purrr::partial(BB, func=!!BBfunc_Gauss)
mygradSIR <- 
    grad_SIR_Gauss <- ## just for ease of reference
        purrr::partial(grad_SIR_generic,
                       rescale=TRUE, ## factor of nn/2
                       AAfunc=!!AA_Gauss, BBfunc=!!BB_Gauss)

####### gradient settings/setup for Laplace




set.seed(501)
library(distr)
myLL <- .7 ## (1/"rate") parameter, aka "mean" parameter (except Laplace mean is 0)
errdist <- DExp(1/myLL)


nn <- 200
mm0 <- function(xx){
   (xx<=0)*0 + (0<=xx & xx<=2)*1 +
       (2<xx & xx<=3)*3 +
       (3<xx)*6
}
xx <- sort(runif(n=nn, 0, 7))
yy <- mm0(xx) + errdist@r(nn)

myScale <- myLL;

## CS settings
#'mysig <- sqrt(2) * myLL;
#' 
AAfunc_Laplace <- purrr::partial(AAfunc_Laplace_generic, LL=!!myLL)
AA_Laplace <- purrr::partial(AA, func=!!AAfunc_Laplace)
BBfunc_Laplace <- purrr::partial(BBfunc_Laplace_generic, LL=!!myLL)
BB_Laplace <- purrr::partial(BB, func=!!BBfunc_Laplace)
mygradSIR <-
    grad_SIR_Laplace <- purrr::partial(grad_SIR_generic,
                                       rescale=TRUE, ## factor of nn/2
                                      AAfunc=!!AA_Laplace, BBfunc=!!BB_Laplace)
}
