% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMRhess.R
\name{UMRhess}
\alias{UMRhess}
\alias{UMRhess_generic}
\title{Compute Hessian of  Unlinked Monotone Regression objective function
    from Balabdaoui, Doss, and Durot}
\usage{
UMRhess_generic(mm, ww_m, yy, ww_y = rep(1/length(yy), length(yy)), dens, BBp)
}
\arguments{
\item{mm}{Current  (unsorted)  estimate/iterate  at  which  to  compute
gradient.  (Length is  <= than  the number  of X  observations in  the
problem).}

\item{ww_m}{Weights (nonnegative,  sum to  1) corresponding to  mm.  Same
length as mm.}

\item{yy}{Y (response) observation vector (numeric)}

\item{ww_y}{Weights (nonnegative,  sum to  1) corresponding to  yy.  Same
length as yy.  Default is just 1/length(yy) for each value.}

\item{dens}{This is the error density, a  function object (Balabdaoui, Doss, Durot (2020+).  Function accepting vector or matrix arguments.}

\item{BBp}{This  is derivative of  "B" function ("B  prime"), where  B is
defined in the paper.  Function accepting vector or matrix arguments.}
}
\description{
Compute Hessian of  Unlinked Monotone Regression objective function
    from Balabdaoui, Doss, and Durot
}
\details{
See paper for derivations.
}
