% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRTPlot.R
\name{PRTPlot}
\alias{PRTPlot}
\title{Plot Precision-Recall or Enrichment-Recall as a function of threshold.}
\usage{
PRTPlot(frame, xvar, truthVar, truthTarget, title, ...,
  plotvars = c("precision", "recall"), thresholdrange = c(-Inf, Inf))
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{truthTarget}{value we consider to be positive}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{plotvars}{variables to plot, must be at least one of "precision", "recall" and "enrichment". Defaults to c("precision", "recall")}

\item{thresholdrange}{range of thresholds to plot.}
}
\description{
Plot Precision-Recall or Enrichment-Recall as a function of threshold.
}
\details{
For a classifier, the precision is what fraction of predicted positives
are true positives; the recall is what fraction of true positives the
classifier finds, and the enrichment is the ratio of classifier precision to
the average rate of positives. Plotting precision-recall or enrichment-recall
as a function of classifier score helps identify a score threshold that achieves
an acceptable tradeoff between precision and recall, or enrichment and recall.
}
\examples{

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(x=x,y=y,yC=y>=as.numeric(quantile(y,probs=0.8)))
frm$absY <- abs(frm$y)
frm$posY = frm$y > 0
frm$costX = 1
WVPlots::PRTPlot(frm, "x", "yC", TRUE, title="Example Precision-Recall threshold plot")

}
\seealso{
\code{\link{PRPlot}}
}
