% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_enrichment.R
\name{improved_pathway_enrichment}
\alias{improved_pathway_enrichment}
\title{Improved Pathway Enrichment Analysis}
\usage{
improved_pathway_enrichment(
  gene_list,
  enrichment_db = "KEGG",
  organism = "hsa",
  org_db = org.Hs.eg.db,
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.2
)
}
\arguments{
\item{gene_list}{A character vector of gene identifiers.}

\item{enrichment_db}{Character string specifying the database for enrichment.
Options include "KEGG", "GO", and "Reactome". Default is "KEGG".}

\item{organism}{Character string specifying the organism code (e.g., "hsa" for human).}

\item{org_db}{database of the organism (e.g: "org.Hs.eg.db")}

\item{pvalueCutoff}{Numeric. P-value cutoff for enrichment (default: 0.05).}

\item{qvalueCutoff}{Numeric. Q-value cutoff for enrichment (default: 0.2).}
}
\value{
An enrichment result object.
}
\description{
Performs pathway enrichment analysis on a set of sex-biased genes using clusterProfiler.
}
