\name{YPmodel.IntervalBands}
\alias{YPmodel.IntervalBands}
\alias{summary.YPmodel.IntervalBands}
\alias{plot.YPmodel.IntervalBands}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Beta confidential intervals & bands
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
A function to calculate the confidential intervals and bands of the hazard ratio function.
}
\usage{

\method{YPmodel}{IntervalBands}(data, Internal, Estimate, ...)
\method{summary}{YPmodel.IntervalBands}(object, Internal, ...)
\method{plot}{YPmodel.IntervalBands}(x, Internal, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{\dots}{ For S4 method only. }
  \item{data}{ A properly qualified filename where text data is to be saved, or a dataframe of input data set with three vectors: the event / censoring time (unite: year), the censoring indicator, and the group membership indicator. See the structure of sample data set \code{\link{gastric}} for instance. } 
  \item{Internal}{ A dataframe of internal parameters, used only to perform hypothesis tests and plot (and to accelerate the speed). }
  \item{Estimate}{ A dataframe of estimation results, including 1) estimation of \eqn{\hat{\beta}}, 2) its confidential intervals and 3) the odds function of the control group \eqn{\hat{R}(t,\hat{\beta})}, generated by \code{\link{YPmodel.estimate}}. }
  \item{x}{ A dataframe of hazard ratios and related confidential intervals and bands, 
  generated by \code{\link{YPmodel.IntervalBands}}. }
  \item{object}{ A dataframe of hazard ratios and related confidential intervals and bands, 
  generated by \code{\link{YPmodel.IntervalBands}}, equally to x (different symbol for S4 method only). }
}
\value{
  \item{hr}{ Estimation of the hazard ratio function. }
  \item{ld2}{ Lower bound of the time frame. }
  \item{ud2}{ Upper bound of the time frame. }
  \item{upp3}{ Upper bounds for the 95\eqn{\%} point-wise conffidence intervals of the hazard ratio function. }
  \item{low3}{ Lower bounds for the 95\eqn{\%} point-wise conffidence intervals of the hazard ratio function. }
  \item{upp22}{ Upper bounds for the 95\eqn{\%}  simultaneous conffidence bands of the hazard ratio function. }
  \item{low22}{ Lower bounds for the 95\eqn{\%}  simultaneous conffidence bands of the hazard ratio function. }
  \item{upp90}{ Upper bounds for the 90\eqn{\%}simultaneous conffidence bands of the hazard ratio function. }
  \item{low90}{ Lower bounds for the 90\eqn{\%}  simultaneous conffidence bands of the hazard ratio function. }
}

\references{
%% ~put references to the literature/web site here ~
YANG, S. AND PRENTICE, R. L. (2011). Estimation of the 2-sample hazard ratio function using a semiparametric model. Biostatistics 12, 354-368. 
}
\author{
%%  ~~who you are~~
Junlong Sun and Song Yang
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{YPmodel}}, \code{\link{YPmodel.estimate}}
}
\examples{
    library(YPmodel)
    data(gastric)
    IntervalBands <- YPmodel.IntervalBands(data=gastric)
    summary.YPmodel.IntervalBands(IntervalBands)
    plot.YPmodel.IntervalBands(IntervalBands)

    Estimate <- YPmodel.estimate(data=gastric, interval=0)
    IntervalBands <- YPmodel.IntervalBands(data=gastric, Estimate=Estimate)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{YPmodel}
