% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/et.abclass.R
\name{et.abclass}
\alias{et.abclass}
\title{Tune Angle-Based Classifiers by ET-Lasso}
\usage{
et.abclass(
  x,
  y,
  intercept = TRUE,
  weight = NULL,
  loss = c("logistic", "boost", "hinge-boost", "lum"),
  control = list(),
  nstages = 2,
  refit = list(lambda = 1e-06),
  ...
)
}
\arguments{
\item{x}{A numeric matrix representing the design matrix.  No missing valus
are allowed.  The coefficient estimates for constant columns will be
zero.  Thus, one should set the argument \code{intercept} to \code{TRUE}
to include an intercept term instead of adding an all-one column to
\code{x}.}

\item{y}{An integer vector, a character vector, or a factor vector
representing the response label.}

\item{intercept}{A logical value indicating if an intercept should be
considered in the model.  The default value is \code{TRUE} and the
intercept is excluded from regularization.}

\item{weight}{A numeric vector for nonnegative observation weights. Equal
observation weights are used by default.}

\item{loss}{A character value specifying the loss function.  The available
options are \code{"logistic"} for the logistic deviance loss,
\code{"boost"} for the exponential loss approximating Boosting machines,
\code{"hinge-boost"} for hybrid of SVM and AdaBoost machine, and
\code{"lum"} for largin-margin unified machines (LUM).  See Liu, et
al. (2011) for details.}

\item{control}{A list of control parameters. See \code{abclass.control()}
for details.}

\item{nstages}{A positive integer specifying for the number of stages in the
ET-Lasso procedure.  By default, two rounds of tuning by random
permutations will be performed as suggested in Yang, et al. (2019).}

\item{refit}{A logical value indicating if a new classifier should be
trained using the selected predictors.  This argument can also be a list
with named elements, which will be passed to \code{abclass.control()} to
specify how the new classifier should be trained.}

\item{...}{Other control parameters passed to \code{abclass.control()}.}
}
\description{
Tune the regularization parameter for an angle-based large-margin classifier
by the ET-Lasso method (Yang, et al., 2019).
}
\references{
Yang, S., Wen, J., Zhan, X., & Kifer, D. (2019). ET-Lasso: A new efficient
tuning of lasso-type regularization for high-dimensional data. In
\emph{Proceedings of the 25th ACM SIGKDD International Conference on
Knowledge Discovery & Data Mining} (pp. 607--616).
}
