% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{LodgepolePines}
\alias{LodgepolePines}
\title{Lodgepole Pine Cone Masses}
\format{A data frame with 16 observations on the following 4 variables.
\describe{ \item{habitat}{a factor with levels: \code{island
absent}, \code{island present}, and \code{mainland present}}
\item{conemass}{mass of cone} \item{location}{\code{island}
or \code{mainland}} \item{squirrels}{\code{absent} or
\code{present}} }}
\source{
Edelaar, P. and C.W. Benkman. 2006. Replicated population divergence
caused by localised coevolution? A test of three hypotheses in the Red
Crossbill-lodgepole pine system. \emph{Journal of Evolutionary Biology} 19:
1651-1659.
}
\description{
Masses of cones of lodgepole pines (\code{conemass}) from 16 different
habitat types (\code{habitat}) in western North America.
}
\examples{
LodgepolePines
str(LodgepolePines)
xyplot(conemass ~ habitat, LodgepolePines)
}
\references{
\url{http://en.wikipedia.org/wiki/Lodgepole_pine}

\url{http://en.wikipedia.org/wiki/Red_crossbill}
}
\keyword{datasets}

