% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abn-toolbox.R
\name{compareEG}
\alias{compareEG}
\title{Compare two DAGs or EGs}
\usage{
compareEG(ref, test)
}
\arguments{
\item{ref}{a matrix or a formula statement (see details for format) defining
the reference network structure, a directed acyclic graph (DAG).
Note that row names must be set or given in \code{node.names}
if the DAG is given via a formula statement.}

\item{test}{a matrix or a formula statement (see details for format) defining
the test network structure, a directed acyclic graph (DAG).
Note that row names must be set or given in \code{node.names}
if the DAG is given via a formula statement.}
}
\value{
\describe{
\item{\code{TP}}{True Positive}
\item{\code{TN}}{True Negative}
\item{\code{FP}}{False Positive}
\item{\code{FN}}{False Negative}
\item{\code{CP}}{Condition Positive (ref)}
\item{\code{CN}}{Condition Negative (ref)}
\item{\code{PCP}}{Predicted Condition Positive (test)}
\item{\code{PCN}}{Predicted Condition Negative (test)}
\item{\code{True Positive Rate}}{\deqn{=\frac{\sum TP}{\sum CP}}{=\frac{\sum TP}{\sum CP}}}
\item{\code{False Positive Rate}}{\deqn{=\frac{\sum FP}{\sum CN}}{=\frac{\sum FP}{\sum CN}}}
\item{\code{Accuracy}}{\deqn{=\frac{\sum TP + \sum TN}{Total population}}{=\frac{\sum TP + \sum TN}{Total population}}}
\item{\code{G-measure}}{\deqn{\sqrt {{\frac {TP}{TP+FP}}\cdot {\frac {TP}{TP+FN}}}}{\sqrt {{\frac {TP}{TP+FP}}\cdot {\frac {TP}{TP+FN}}}}}
\item{\code{F1-Score}}{\deqn{\frac{2 \sum TP}{2 \sum TP + \sum FN + \sum FP}}{\frac{2 \sum TP}{2 \sum TP + \sum FN + \sum FP}}}
\item{\code{Positive Predictive Value}}{\deqn{\frac{\sum TP}{\sum PCP}}{\frac{\sum TP}{\sum PCP}}}
\item{\code{False Ommision Rate}}{\deqn{\frac{\sum FN}{\sum PCN}}{\frac{\sum FN}{\sum PCN}}}
\item{\code{Hamming-Distance}}{Number of changes needed to match the matrices.}
}
}
\description{
Function that returns multiple graph metrics to compare two DAGs
or essential graphs, known as confusion matrix or error matrix.
}
\details{
This R function returns standard Directed Acyclic Graph comparison metrics.
In statistical classification, those metrics are known as a
confusion matrix or error matrix.

Those metrics allows visualization of the difference between different DAGs.
In the case where comparing TRUTH to learned structure or two learned structures,
those metrics allow the user to estimate the performance of the learning algorithm.
In order to compute the metrics, a contingency table is computed of a
pondered difference of the adjacency matrices od the two graphs.

The \code{ref} or \code{test} can be provided using a formula statement
(similar to GLM input).
A typical formula is \code{ ~ node1|parent1:parent2 + node2:node3|parent3}.
The formula statement have to start with \code{~}.
In this example, node1 has two parents (parent1 and parent2).
node2 and node3 have the same parent3.
The parents names have to exactly match those given in \code{node.names}.
\code{:} is the separtor between either children or parents,
\code{|} separates children (left side) and parents (right side),
\code{+} separates terms, \code{.} replaces all the variables in \code{node.names}.

To test for essential graphs (or graphs) in general, the test for DAG
need to be switched off \code{checkDAG=FALSE}.
The function \code{compareEG()} is a wrapper to \code{compareDag(, checkDAG=FALSE)}.
}
\examples{
test.m <- matrix(data = c(0,1,0,
                          0,0,0,
                          1,0,0), nrow = 3, ncol = 3)
ref.m <- matrix(data = c(0,0,0,
                         1,0,0,
                         1,0,0), nrow = 3, ncol = 3)

colnames(test.m) <- rownames(test.m) <- colnames(ref.m) <- rownames(ref.m) <- c("a", "b", "c")

unlist(compareDag(ref = ref.m, test = test.m))
}
\references{
Sammut, Claude, and Geoffrey I. Webb. (2017). Encyclopedia of machine learning and data mining. Springer.
}
