% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_transform_interaction.R
\name{acled_transform_interaction}
\alias{acled_transform_interaction}
\title{Change interaction codes from numeric labels to string labels}
\usage{
acled_transform_interaction(df, only_inters = FALSE)
}
\arguments{
\item{df}{dataframe. ACLED data including at least inter1, inter2 columns. If \code{only_inters} is TRUE, it also requires interaction column.}

\item{only_inters}{boolean. Option whether to include the \emph{interaction} column in the transformation (if TRUE) or to only use \emph{inter1} and \emph{inter2} (if FALSE).}
}
\value{
Returns a tibble of of ACLED events with modified \emph{inter1}, \emph{inter2} and potentially \emph{interaction} columns .
}
\description{
This function allows users to change from numeric interaction codes (i.e. 1, 2, 3, etc) to string interaction codes (i.e. State Forces, Rebel Group, etc.)
}
\examples{
\dontrun{

# Load data frame
argen_acled <- acled_api(
  email = "your_email", key = "your_key",
  country = "Argentina", start_date = "2022-01-01", end_date = "2022-02-01",
  acled_access = FALSE
)

# Transform the interactions
argen_acled_transformed <- acled_transformation_interaction(argen_acled, only_inters = F)
}
}
\seealso{
Other Data Manipulation: 
\code{\link{acled_transform_longer}()},
\code{\link{acled_transform_wider}()}
}
\concept{Data Manipulation}
