% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move.R
\name{copy_adf_entry}
\alias{copy_adf_entry}
\alias{copy_adf_entry.character}
\alias{copy_adf_entry.virtual_path}
\alias{copy_adf_entry.character.virtual_path}
\alias{copy_adf_entry.virtual_path.virtual_path}
\alias{copy_adf_entry.virtual_path.character}
\alias{move_adf_entry}
\alias{move_adf_entry.character}
\alias{move_adf_entry.virtual_path}
\alias{move_adf_entry.character.virtual_path}
\alias{move_adf_entry.virtual_path.virtual_path}
\alias{move_adf_entry.virtual_path.character}
\title{Copy or move files between physical and virtual devices}
\usage{
copy_adf_entry(source, destination, ...)

\method{copy_adf_entry}{character}(source, destination, ...)

\method{copy_adf_entry}{virtual_path}(source, destination, ...)

\method{copy_adf_entry.character}{virtual_path}(source, destination, ...)

\method{copy_adf_entry.virtual_path}{virtual_path}(source, destination, ...)

\method{copy_adf_entry.virtual_path}{character}(source, destination, ...)

move_adf_entry(source, destination, ...)

\method{move_adf_entry}{character}(source, destination, ...)

\method{move_adf_entry}{virtual_path}(source, destination, ...)

\method{move_adf_entry.character}{virtual_path}(source, destination, ...)

\method{move_adf_entry.virtual_path}{virtual_path}(source, destination, ...)

\method{move_adf_entry.virtual_path}{character}(source, destination, ...)
}
\arguments{
\item{source, destination}{The \code{source} is a path to a file or directory that needs
to be moved or copied. \code{destination} is a path to a directory to which the \code{source}
needs to be copied or moved. When \code{source} or \code{destination} is a \code{character} string,
it is assumed to be a path to a file or directory on a physical device. You
can use a \code{\link[=virtual_path]{virtual_path()}} for either the \code{source} or \code{destination} or both.
\code{source} and \code{destination} cannot both be a \code{character} string. For copying and moving
files on a physical device you should you \code{base} function \code{\link[=file.copy]{file.copy()}}.}

\item{...}{Ignored}
}
\description{
With these functions you can copy or move entries (files and directories) between
a physical and virtual ADF device. With \code{copy_adf_entry()} the files are duplicated,
with \code{move_adf_entry()} the files are moved (and deleted from its source).
}
\examples{
## Create an Amiga Disk File
## and prepare a file system on the virtual device
my_device <-
  create_adf_device(
    tempfile(fileext = ".adf"),
    write_protected = FALSE) |>
  prepare_adf_device()

## Copy the packaged R scripts of this package to the virtual device
copy_adf_entry(
  system.file("R", package = "adfExplorer"),
  virtual_path(my_device, "DF0:")
)

## List all entries on the virtual device
list_adf_entries(my_device, recursive = TRUE)

## Move the entire virtual device content to
## the tempdir on your physical device
dest <- file.path(tempdir(), "DF0")
dir.create(dest)
move_adf_entry(
  virtual_path(my_device, "DF0:"),
  dest
)

## cleanup the temp directory
unlink(dest, recursive = TRUE)

close(my_device)
}
\author{
Pepijn de Vries
}
