% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmAdhesionEnergy.R
\name{afmAdhesionEnergy}
\alias{afmAdhesionEnergy}
\title{Adhesion Energy}
\usage{
afmAdhesionEnergy(afmdata, width = 1, lagdiff = width, mul, mdj = NULL)
}
\arguments{
\item{afmdata}{An afmdata or afmexperiment class variables. Baseline correction should
have been done already.}

\item{width}{Width of the window for the local regression (in vector position units)}

\item{lagdiff}{Lag for estimating the differences in Delta (or slopes) signal. 
By default it takes the same value as the window with.}

\item{mul}{Multiplier for the calculating the threshold inthe estimation of jumps 
and peaks in the Delta signal}

\item{mdj}{Minimum distance between jumps. If none is given then it will be set equal 
to \code{width}}
}
\value{
An \code{afmdata} class variable which will consist on the original 
input \code{afmdata} variable plus a new list named \code{AdhEner} with the 
following fields:

\code{Points} Array containing the indices of the retract segment where the adhesion 
begins, the unbinding event takes place and the adhesion ends.

\code{Energies} Data frame with three columns: \code{E1adh}, \code{E2adh} and 
\code{Etotal}, being the first one the energy from the begining of the adhesion until
the unbinding event, then second one the energy from the unbinding event until the full
detachment of the tip, and the third one, the sum of them.
}
\description{
Finds the adhesion and the full detach energies from the retract segment of the AFM 
F-d curve.
}
\examples{
path <- path.package("afmToolkit")
data <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path)
data <- afmContactPoint(data, width = 20, mul1 = 1, mul2 = 10)
data <- afmDetachPoint(data, width = 20, mul1 = 2, mul2 = 30)
data <- afmBaselineCorrection(data)
data <- afmAdhesionEnergy(data, width = 20, mul = 10)
str(data$AdhEner)
}

