% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reaggregate_counts.R
\name{reaggregate_counts}
\alias{reaggregate_counts}
\title{Reaggregate age counts}
\usage{
reaggregate_counts(
  bounds,
  counts,
  new_bounds,
  ...,
  population_bounds = NULL,
  population_weights = NULL
)
}
\arguments{
\item{bounds}{\verb{[numeric]}

The \emph{current} boundaries in (strictly) increasing order.

These correspond to the left hand side of the intervals (e.g. the
closed side of [x, y).

Double values are coerced to integer prior to categorisation.}

\item{counts}{\verb{[numeric]}

Vector of counts corresponding to the intervals defined by \code{bounds}.}

\item{new_bounds}{\verb{[numeric]}

The \emph{desired} boundaries in (strictly) increasing order.}

\item{...}{Further arguments passed to or from other methods.}

\item{population_bounds}{\verb{[numeric]}

Interval boundaries for a known population weighting given by the
\code{population_weights} argument.}

\item{population_weights}{\verb{[numeric]}

Population weightings corresponding to \code{population_bounds}.

Used to weight the output across the desired intervals.

If \code{NULL} (default), counts are divided proportional to the interval sizes.}
}
\value{
A data frame with 4 entries; \code{interval}, \code{lower}, \code{upper} and a
corresponding \code{count}.
}
\description{
\code{reaggregate_counts()} converts counts over one interval range to another
with optional weighting by a known population.
}
\examples{

# Reaggregating some data obtained from the 2021 UK census
head(pop_dat)

# Each row of the data is for the same region so we can drop some columns
# `age_category` and `value` columns
dat <- subset(pop_dat, select = c(age_category, value))

# Add the lower bounds to the data
dat <- transform(
    dat,
    lower_bound = as.integer(sub("\\\\[([0-9]+), .+)", "\\\\1", age_category))
)

# Now recategorise to the desired age intervals
with(
    dat,
    reaggregate_counts(
        bounds = lower_bound,
        counts = value,
        new_bounds = c(0, 1, 5, 15, 25, 45, 65)
    )
)

}
