% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_akstats.R
\name{plot_akstats}
\alias{plot_akstats}
\title{Plot of cluster groups.}
\usage{
plot_akstats(
  ak_object,
  k = 3,
  reference = 1,
  n_quant = 4,
  type = "lines",
  y_scaling = "fixed"
)
}
\arguments{
\item{ak_object}{An output of \code{\link{akclustr}} function.
The object contains individual trajectories and their cluster
solution(s) at the specified values of \code{k}. Also, includes
the optimal value of \code{k} based on the criterion specified.
at (different) values of \code{k} the \code{traj}.}

\item{k}{[integer] \code{k} cluster to generate its solution.}

\item{reference}{[numeric] Specifying the reference line from
which the direction of each group is measured. Options are:
\code{1}: slope of mean trajectory, \code{2}: slope of medoid
trajectory, \code{3}: slope of a horizontal line
(i.e. slope = 0). Default: \code{1}.}

\item{n_quant}{[numeric] Number of equal intervals (quantiles)
to create between the reference line \code{(R)} and the medoids
\code{(M)} of the most-diverging groups of both sides of
\code{(R)}. Default is \code{4} - meaning quartile subdivisions
on each side of \code{(R)}. In this scenario, the function
returns the quartile in which the medoid of each group falls.
This result can be used to further categorize the groups into
'classes'. For example, groups that fall within the \code{1st}
quartile may be classified as 'Stable' groups (Adepeju et al. 2021).}

\item{type}{[character] plot type. Available options are:
\code{"lines"} and \code{"stacked"}.}

\item{y_scaling}{[character] works only if \code{type="lines"}.
\code{y_scaling} set the vertical scales of the cluster panels.
Options are: \code{"fixed"}: uses uniform scale for all panels,
\code{"free"}: uses variable scales for panels.}
}
\value{
A plot showing group membership or sizes (proportion)
and statistics.
}
\description{
Takes the 'ak_object' from the
\code{'akclustr'} as input and produce either the 'line' plot
or 'stacked' histogram.
}
\details{
Generates the plots of cluster groups - same plots
generated by the \code{'show_plots'} argument of \code{print_akstats}.
The function draw from the functionalities of the
\code{ggplot2} library.
For a more customized visualisation, we recommend that users
deploy \code{ggplot2} directly (\code{Wickham H. (2016)}).
}
\examples{

data(traj)

trajectry <- data_imputation(traj, id_field = TRUE, method = 1,
replace_with = 1, fill_zeros = FALSE)

print(trajectry$CompleteData)

trajectry <- props(trajectry$CompleteData, id_field = TRUE)

aksolution <- akclustr(trajectry, id_field = TRUE,
method = "linear", k = c(3,5), crit='Calinski_Harabasz')

plot_akstats(aksolution, k = 4, type="lines",
y_scaling="fixed")

plot_akstats(aksolution, k = 4, reference = 1,
n_quant = 4, type="stacked")

}
\references{
\code{1}. Adepeju, M. et al. (2021). Anchored k-medoids:
A novel adaptation of k-medoids further refined to measure
inequality in the exposure to crime across micro places,
doi: 10.1007/s42001-021-00103-1.

\code{2}. Wickham H. (2016). Elegant graphics for
Data Analysis. Spring-Verlag New York (2016).
}
