% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_plot_datayear.R
\name{amf_plot_datayear}
\alias{amf_plot_datayear}
\title{Plot data availability}
\usage{
amf_plot_datayear(
  data_aval = NULL,
  site_set = NULL,
  var_set = NULL,
  nonfilled_only = TRUE,
  year_set = NULL
)
}
\arguments{
\item{data_aval}{A data frame with at least five columns:
\itemize{
  \item SITE_ID:
  \item VARIABLE:
  \item BASENAME: variable basename
  \item GAP_FILLED
  \item Y1990: Percentage of data availability in the year 1990 (0-1).
  \item ...
 }
 If not specified, use \code{\link{amf_list_data}} by default.}

\item{site_set}{A scalar or vector of character specifying the target
AmeriFlux Site ID (CC-Sss). If not specified, it returns all sites.}

\item{var_set}{A scalar or vector of character specifying the target
variables as in basename. See AmeriFlux
page\url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/#base}
for a list of variable names. If not specified, it returns all variables.}

\item{nonfilled_only}{Logical, whether only showing non-filled variables,
or both non- and gap-filled variables. The default is TRUE.}

\item{year_set}{A scalar or vector of integers. If not specified,
it plots only years with any available data in selected sites and variables}
}
\value{
An object of class 'plotly' from \code{\link[heatmaply]{heatmaply}}
}
\description{
This function visualizes the BASE data availability for
selected AmeriFlux sites, variables, and years. This is a wrapper around
\code{\link{amf_list_data}}. However, it is strongly advised to subset
the sites, variables, and/or years for faster processing and better
visualization.
}
\examples{
\dontrun{
# plot data availability for all variables at a single site
#  in all years
amf_plot_datayear(site_set = "US-CRT",
                  nonfilled_only = FALSE)

# plot data availability for non-filled FCH4 and WTD at all
#  sites in all years
amf_plot_datayear(var_set = c("FCH4", "WTD"),
                  nonfilled_only = TRUE)

# plot data availability for non-filled FCH4 at all sites
#  in 2018-2020
amf_plot_datayear(var_set = "FCH4",
                  year_set = c(2018:2020),
                  nonfilled_only = TRUE)
}
}
\seealso{
\code{\link{amf_list_data}}, \code{\link[heatmaply]{heatmaply}}
}
