% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CournotClasses.R
\docType{class}
\name{Cournot-classes}
\alias{Cournot-classes}
\alias{Cournot-class}
\alias{Stackelberg-class}
\title{\dQuote{Cournot} Classes}
\description{
The \dQuote{Cournot} and \dQuote{Stackelberg} classes are building blocks used to create other classes
in this package. As such, they are most likely to be useful for developers
who wish to code their own merger calibration/simulation routines.

Note below that k is the number of products and n is the number of plants.
}
\section{Slots}{

\describe{
\item{\code{intercepts}}{A length k vector containing the calibrated demand intercept.}

\item{\code{mcfunPre}}{A length n list whose elements equal a function that calculates a plant's pre-merger marginal cost.}

\item{\code{mcfunPost}}{A length n list whose elements equal a function that calculates a plant's post-merger marginal cost.}

\item{\code{vcfunPre}}{A length n list whose elements equal a function that calculates a plant's pre-merger variable cost.}

\item{\code{vcfunPost}}{A length n list whose elements equal a function that calculates a plant's post-merger variable cost.}

\item{\code{prices}}{A length k vector of product prices.}

\item{\code{quantities}}{An n x k matrix of plant quantities produced for each product.}

\item{\code{margins}}{An n x k matrix of plant product margins.}

\item{\code{quantityPre}}{An n x k matrix of predicted pre-merger quantities.}

\item{\code{quantityPost}}{An n x k matrix of predicted post-merger quantities.}

\item{\code{quantityStart}}{A length n x k vector of starting quantities for the non-linear solver.}

\item{\code{productsPre}}{An n x k logical matrix qhose elements are TRUE if a plant produces a product pre-merger and FALSE otherwise.}

\item{\code{productsPost}}{An n x k logical matrix qhose elements are TRUE if a plant produces a product post-merger and FALSE otherwise.}

\item{\code{capacitiesPre}}{A length-n logical vector whose elements equal to pre-merger plant capacities. Infinite values are allowed.}

\item{\code{capacitiesPost}}{A length-n logical vector whose elements equal to post-merger plant capacities. Infinite values are allowed.}

\item{\code{demand}}{A length k character vector specifying whether product demand is linear ("linear") or log-linear ("log").}

\item{\code{cost}}{A length k character vector equal to "linear" if a plant's marginal cost curve is assumed to be linear
or "constant" if a plant's marginal curve is assumed to be constant.
Returns an error if a multi-plant firm with constant marginal costs does not have capacity constraints.}

\item{\code{mktElast}}{A length k vector of market elasticities.}

\item{\code{dmcfunPre}}{A length n list whose elements equal a function that calculates the derivative of a
plant's pre-merger marginal cost with respect to that plant's output. (Stackelberg only)}

\item{\code{dmcfunPost}}{A length n list whose elements equal a function that calculates the derivative of a
plant's post-merger marginal cost with respect to that plant's output. (Stackelberg only)}

\item{\code{isLeaderPre}}{An n x k logical matrix qhose elements are TRUE if a plant produces a product pre-merger and FALSE otherwise. (Stackelberg only)}

\item{\code{isLeaderPost}}{An n x k logical matrix qhose elements are TRUE if a plant produces a product post-merger and FALSE otherwise. #'@slot dmcfunPre A length n list whose elements equal a function that calculates the derivative of a
plant's pre-merger marginal cost with respect to that plant's output. (Stackelberg only)}
}}

\section{Objects from the Class}{

For Cournot, objects can be created by calls of the form \code{new("Cournot", ...)}.

For Stackelberg, objects can be created by calls of the form \code{new("Stackelberg", ...)}.
}

\section{Extends}{

Cournot:
Class \code{\linkS4class{Bertrand}}, directly.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 2.

Stackelberg:
Class \code{\linkS4class{Cournot}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Cournot}}, distance 2.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 3.
}

\examples{
showClass("Cournot")           # get a detailed description of the class
showClass("Stackelberg")           # get a detailed description of the class
}
\author{
Charles Taragin \email{ctaragin+antitrustr@gmail.com}
}
\keyword{classes}
