% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HHIMethods.R
\docType{methods}
\name{HHI-Methods}
\alias{HHI-Methods}
\alias{hhi}
\alias{hhi,ANY-method}
\alias{hhi,Bertrand-method}
\alias{hhi,Cournot-method}
\alias{hhi,VertBargBertLogit-method}
\title{Methods For Calculating the Herfindahl-Hirschman Index}
\usage{
\S4method{hhi}{Bertrand}(object, preMerger = TRUE, revenue = FALSE, insideonly = TRUE)

\S4method{hhi}{Cournot}(object, preMerger = TRUE, revenue = FALSE)

\S4method{hhi}{VertBargBertLogit}(object, preMerger = TRUE, revenue = FALSE, insideonly = TRUE)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{preMerger}{If TRUE, returns pre-merger outcome. If
FALSE, returns post-merger outcome.  Default is TRUE.}

\item{revenue}{If TRUE, returns revenues. If FALSE,
returns quantities. Default is TRUE.}

\item{insideonly}{If TRUE, excludes the share of the outside good from the calculation.
Default is TRUE.}
}
\description{
Computes the  Herfindahl-Hirschman Index (HHI) using simulated market
shares and either pre- or post-merger ownership information.
Outside shares are excluded from the calculation.
}
\keyword{methods}
