% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-options.R
\name{boxplot_opts}
\alias{boxplot_opts}
\title{Boxplot options}
\usage{
boxplot_opts(color.upper, color.lower, ...)
}
\arguments{
\item{color.upper}{Color for the upper quartile (Q3 to median) of the box plot.}

\item{color.lower}{Color for the lower quartile (median to Q1) of the box plot.}

\item{...}{Additional parameters.}
}
\value{
A \code{list} of options that can be used in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\description{
Use these options in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\note{
See \url{https://apexcharts.com/docs/options/plotoptions/boxplot/}.
}
\examples{
data("mpg", package = "ggplot2")
apex(mpg, aes(class, hwy), "boxplot") \%>\% 
  ax_plotOptions(
    boxPlot = boxplot_opts(color.upper = "#848484", color.lower = "#848484" )
  )
}
