% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ari_stitch.R
\name{ari_stitch}
\alias{ari_stitch}
\title{Create a video from images and audio}
\usage{
ari_stitch(images, audio, output = tempfile(fileext = ".mp4"),
  verbose = FALSE, cleanup = TRUE, ffmpeg_opts = "",
  divisible_height = TRUE, audio_codec = get_audio_codec(),
  video_codec = get_video_codec(), video_sync_method = "-1",
  audio_bitrate = NULL, video_bitrate = NULL,
  pixel_format = "yuv420p", fast_start = TRUE, deinterlace = TRUE,
  stereo_audio = TRUE)
}
\arguments{
\item{images}{A vector of paths to images.}

\item{audio}{A list of \code{Wave}s from tuneR.}

\item{output}{A path to the video file which will be created.}

\item{verbose}{print diagnostic messages.  If > 1, then more are printed}

\item{cleanup}{If \code{TRUE}, interim files are deleted}

\item{ffmpeg_opts}{additional options to send to \code{ffmpeg}.
This is an advanced option, use at your own risk}

\item{divisible_height}{Make height divisible by 2, which may 
be required if getting "height not divisible by 2" error.}

\item{audio_codec}{The audio encoder for the splicing.  If this
fails, try \code{copy}.}

\item{video_codec}{The video encoder for the splicing.  If this
fails, see \code{ffmpeg -codecs}}

\item{video_sync_method}{Video sync method.  Should be 
"auto" or `"vfr"` or a numeric.  See \url{https://ffmpeg.org/ffmpeg.html}.}

\item{audio_bitrate}{Bit rate for audio. Passed to \code{-b:a}.}

\item{video_bitrate}{Bit rate for video. Passed to \code{-b:v}.}

\item{pixel_format}{pixel format to encode for `ffmpeg`.}

\item{fast_start}{Adding `faststart` flags for YouTube and other sites,
see \url{https://trac.ffmpeg.org/wiki/Encode/YouTube}}

\item{deinterlace}{should the video be de-interlaced, 
see \url{https://ffmpeg.org/ffmpeg-filters.html}, generally for 
YouTube}

\item{stereo_audio}{should the audio be forced to stereo,
corresponds to `-ac 2`}
}
\value{
A logical value, with the attribute \code{outfile} for the
output file.
}
\description{
Given a vector of paths to images (preferably \code{.jpg}s
or \code{.png}s) and a flat list of \code{\link[tuneR]{Wave}}s of equal
length this function will create an \code{.mp4} video file where each image 
is shown with its corresponding audio. Take a look at the
\code{\link[tuneR]{readWave}} function if you want to import your audio 
files into R. Please be sure that all images have the same dimensions.
}
\details{
This function uses \href{https://ffmpeg.org/}{FFmpeg}
which you should be sure is installed before using this function. If running
\code{Sys.which("ffmpeg")} in your R console returns an empty string after
installing FFmpeg then you should set the path to FFmpeg on you computer to
an environmental variable using \code{Sys.setenv(ffmpeg = "path/to/ffmpeg")}.
The environmental variable will always override the result of
\code{Sys.which("ffmpeg")}.
}
\examples{
\dontrun{
if (ffmpeg_version_sufficient()) {
result = ari_stitch(
ari_example(c("mab1.png", "mab2.png")),
list(tuneR::noise(), tuneR::noise()))
} 
}
}
