% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonmemControl.R
\name{nonmemControl}
\alias{nonmemControl}
\title{NONMEM estimation control}
\usage{
nonmemControl(
  est = c("focei", "imp", "its", "posthoc"),
  advanOde = c("advan13", "advan8", "advan6"),
  cov = c("r,s", "r", "s", ""),
  maxeval = 1e+05,
  tol = 6,
  atol = 12,
  sstol = 6,
  ssatol = 12,
  sigl = 12,
  sigdig = 3,
  print = 1,
  extension = getOption("babelmixr2.nmModelExtension", ".nmctl"),
  outputExtension = getOption("babelmixr2.nmOutputExtension", ".lst"),
  runCommand = getOption("babelmixr2.nonmem", ""),
  iniSigDig = 5,
  protectZeros = TRUE,
  muRef = TRUE,
  addProp = c("combined2", "combined1"),
  rxControl = NULL,
  sumProd = FALSE,
  optExpression = TRUE,
  calcTables = TRUE,
  compress = TRUE,
  ci = 0.95,
  sigdigTable = NULL,
  readRounding = FALSE,
  readBadOpt = FALSE,
  niter = 100L,
  isample = 1000L,
  iaccept = 0.4,
  iscaleMin = 0.1,
  iscaleMax = 10,
  df = 4,
  seed = 14456,
  mapiter = 1,
  mapinter = 0,
  noabort = TRUE,
  modelName = NULL,
  muRefCovAlg = TRUE,
  ...
)
}
\arguments{
\item{est}{NONMEM estimation method}

\item{advanOde}{The ODE solving method for NONMEM}

\item{cov}{The NONMEM covariance method}

\item{maxeval}{NONMEM's maxeval (for non posthoc methods)}

\item{tol}{NONMEM tolerance for ODE solving advan}

\item{atol}{NONMEM absolute tolerance for ODE solving}

\item{sstol}{NONMEM tolerance for steady state ODE solving}

\item{ssatol}{NONMEM absolute tolerance for steady state ODE solving}

\item{sigl}{NONMEM sigl estimation option}

\item{sigdig}{the significant digits for NONMEM}

\item{print}{The print number for NONMEM}

\item{extension}{NONMEM file extensions}

\item{outputExtension}{Extension to use for the NONMEM output
listing}

\item{runCommand}{Command to run NONMEM (typically the path to "nmfe75") or a
function.  See the details for more information.}

\item{iniSigDig}{How many significant digits are printed in $THETA
and $OMEGA when the estimate is zero.  Also controls the zero
protection numbers}

\item{protectZeros}{Add methods to protect divide by zero}

\item{muRef}{Automatically mu-reference the control stream}

\item{addProp, sumProd, optExpression, calcTables, compress, ci, sigdigTable}{Passed to \code{nlmixr2est::foceiControl}}

\item{rxControl}{Options to pass to \code{rxode2::rxControl} for
simulations}

\item{readRounding}{Try to read NONMEM output when NONMEM
terminated due to rounding errors}

\item{readBadOpt}{Try to read NONMEM output when NONMEM terminated
due to an apparent failed optimization}

\item{niter}{number of iterations in NONMEM estimation methods}

\item{isample}{Isample argument for NONMEM  ITS estimation method}

\item{iaccept}{Iaccept for NONMEM ITS estimation methods}

\item{iscaleMin}{parameter for IMP NONMEM method (ISCALE_MIN)}

\item{iscaleMax}{parameter for IMP NONMEM method (ISCALE_MAX)}

\item{df}{degrees of freedom for IMP method}

\item{seed}{is the seed for NONMEM methods}

\item{mapiter}{the number of map iterations for IMP method}

\item{mapinter}{is the MAPINTER parameter for the IMP method}

\item{noabort}{Add the \code{NOABORT} option for \verb{$EST}}

\item{modelName}{Model name used to generate the NONMEM output.  If
\code{NULL} try to infer from the model name (could be \code{x} if not
clear).  Otherwise use this character for outputs.}

\item{muRefCovAlg}{This controls if algebraic expressions that can
  be mu-referenced are treated as mu-referenced covariates by:

  1. Creating a internal data-variable `nlmixrMuDerCov#` for each
     algebraic mu-referenced expression

  2. Change the algebraic expression to `nlmixrMuDerCov# * mu_cov_theta`

  3. Use the internal mu-referenced covariate for saem

  4. After optimization is completed, replace `model({})` with old
  `model({})` expression

  5. Remove `nlmixrMuDerCov#` from nlmix2 output

In general, these covariates should be more accurate since it
changes the system to a linear compartment model.  Therefore, by default this is `TRUE`.}

\item{...}{optional \code{genRxControl} argument controlling
automatic \code{rxControl} generation.}
}
\value{
babelmixr2 control option for generating NONMEM control stream and
reading it back into \code{babelmixr2}/\code{nlmixr2}
}
\description{
NONMEM estimation control
}
\details{
If \code{runCommand} is given as a string, it will be called with the
\code{system()} command like:

\code{runCommand controlFile outputFile}.

For example, if \code{runCommand="'/path/to/nmfe75'"} then the command line
used would look like the following:

\code{'/path/to/nmfe75' one.cmt.nmctl one.cmt.lst}

If \code{runCommand} is given as a function, it will be called as
\code{FUN(ctl, directory, ui)} to run NONMEM.  This allows you to run NONMEM
in any way that you may need, as long as you can write it in R.  babelmixr2
will wait for the function to return before proceeding.

If \code{runCommand} is \code{NA}, \code{nlmixr()} will stop after writing
the model files and without starting NONMEM.
}
\examples{

nonmemControl()

}
\author{
Matthew L. Fidler
}
