% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.hypergeometric}
\alias{sparsify.with.hypergeometric}
\title{Extract Goldberg and Roth's (2003) Hypergeometric backbone}
\usage{
sparsify.with.hypergeometric(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \link[Matrix]{Matrix}; (2) an edgelist in the form of a two-column dataframe; (3) an \link[igraph]{igraph} object.}

\item{s}{numeric: Sparsificiation threshold, 0 < s < 1; smaller values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "Matrix", "igraph", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.hypergeometric} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the hypergeometric backbone described by Goldberg and Roth (2003).
It is equivalent to \code{sparsify(escore = "hypergeometric", normalize = "none", filter = "threshold", umst = FALSE)}.
}
\examples{
U <- igraph::sample_sbm(60, matrix(c(.75,.25,.25,.25,.75,.25,.25,.25,.75),3,3), c(20,20,20))
plot(U) #A hairball
sparse <- sparsify.with.hypergeometric(U, s = 0.3, narrative = TRUE)
plot(sparse) #Clearly visible communities
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

model: {Goldberg, D. S., & Roth, F. P. (2003). Assessing experimentally derived interactions in a small world. \emph{Proceedings of the National Academy of Sciences, 100}, 4372-4376. \doi{10.1073/pnas.0735871100}}
}
