% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_details.R
\name{get_details.bhm}
\alias{get_details.bhm}
\title{Get Details of a BHM Basket Trial Simulation}
\usage{
\method{get_details}{bhm}(
  design,
  n,
  p1 = NULL,
  lambda,
  level = 0.95,
  tau_scale,
  iter = 1000,
  n_mcmc = 10000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{bhm}.}

\item{n}{The sample size per basket.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{tau_scale}{Standard deviation of the half normal prior distribution
for the variance of the thetas.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{n_mcmc}{Number of MCMC samples.}

\item{data}{An object of class \code{scenario_list} as returned by the
function \code{bhmbasket::simulateScenarios}.}

\item{...}{Further arguments.}
}
\value{
A list containing the rejection probabilites, posterior means,
mean squared errors and mean limits of HDI intervals for all baskets as well
as the family-wise error rate.
}
\description{
Get Details of a BHM Basket Trial Simulation
}
\examples{
design <- setup_bhm(k = 3, p0 = 0.2, p_target = 0.5)
\donttest{get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, tau_scale = 1, iter = 100)}
}
