% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particle_filter-doc.R
\name{particle_filter_model_specification}
\alias{particle_filter_model_specification}
\title{Model Specification for Particle Filters}
\description{
Model Specification for Particle Filters
}
\section{Model Specification}{

Particle filter implementations in this package assume a discrete-time
state-space model defined by:

\itemize{
  \item A sequence of latent states \eqn{x_0, x_1, \ldots, x_T} evolving
  according to a Markov process.
  \item Observations \eqn{y_1, \ldots, y_T} that are conditionally independent
  given the corresponding latent states.
}

The model is specified as:
\deqn{x_0 \sim \mu_\theta}
\deqn{x_t \sim f_\theta(x_t \mid x_{t-1}), \quad t = 1, \ldots, T}
\deqn{y_t \sim g_\theta(y_t \mid x_t), \quad t = 1, \ldots, T}

where \eqn{\theta} denotes model parameters passed via \code{...}.

The user provides the following functions:
\itemize{
  \item \code{init_fn}: draws from the initial distribution
  \eqn{\mu_\theta}.
  \item \code{transition_fn}: generates or evaluates the transition
  density \eqn{f_\theta}.
  \item \code{weight_fn}: evaluates the observation likelihood
  \eqn{g_\theta}.
}
}

\keyword{internal}
