% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{Param}
\alias{Param}
\title{Construct a parameter with a prior, weight and an update flag.}
\usage{
Param(
  init,
  weight = if_else(init == 0, 0, 1),
  update = weight > 0,
  prior = init
)
}
\arguments{
\item{init}{the initial value of the parameter.}

\item{weight}{the weight of the prior.}

\item{update}{a flag indicating if the parameter shouldbe updated in the MCMC.}

\item{prior}{mean value of the prior distribution, may be used with weight to fully determine prior parameters.}
}
\value{
A list with the following elements:
\itemize{
\item \code{init} the initial value of the parameter.
\item \code{weight} the weight of the prior.
\item \code{update} a flag indicating if the parameter shouldbe updated in the MCMC.
\item \code{prior} mean value of the prior distribution, may be used with weight to fully determine prior parameters.
}
}
\description{
Construct a parameter with a prior, weight and an update flag.
}
\examples{
# Fully specified parameter.
Param(init = 0, weight = 1, update = TRUE, prior = 0.5)
# Fixed parameter
# Weight = 0 implies update=FALSE and prior is ignored.
Param(0, 0)
# Update parameter that starts at zero.
Param(0, weight =1, update=TRUE)
# Parameters specified at zero implies fixed.
Param(0)
}
