% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_functions.R
\name{coef.bbreg}
\alias{coef.bbreg}
\title{coef.bbreg}
\usage{
\method{coef}{bbreg}(object, parameters = c("all", "mean", "precision"), ...)
}
\arguments{
\item{object}{object of class "bbreg" containing results from the fitted model.}

\item{parameters}{a string to determine which coefficients should be extracted: 'all' extracts all coefficients, 'mean' extracts the coefficients of the mean parameters and 'precision' extracts coefficients of the precision parameters.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Function to extract the coefficients of a fitted regression model (bessel or beta).
}
\examples{
\donttest{
fit = bbreg(agreement ~ priming + eliciting, data = WT)
coef(fit)
coef(fit, parameters = "precision")}
}
\seealso{
\code{\link{fitted}}, \code{\link{summary}}, \code{\link{vcov}}, \code{\link{plot}}, \code{\link{predict}}
}
