% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_Bes.R
\name{Qf_bes}
\alias{Qf_bes}
\title{Qf_bes}
\usage{
Qf_bes(theta, wz, z, x, v, link.mean, link.precision)
}
\arguments{
\item{theta}{vector of parameters (all coefficients: kappa and lambda).}

\item{wz}{parameter representing E(1/W_i|Z_i = z_i, theta).}

\item{z}{response vector with 0 < z_i < 1.}

\item{x}{matrix containing the covariates for the mean submodel. Each column is a different covariate.}

\item{v}{matrix containing the covariates for the precision submodel. Each column is a different covariate.}

\item{link.mean}{a string containing the link function for the mean.
The possible link functions for the mean are "logit","probit", "cauchit", "cloglog".}

\item{link.precision}{a string containing the link function the precision parameter.
The possible link functions for the precision parameter are "identity", "log", "sqrt", "1/precision^2", "inverse".}
}
\value{
Scalar representing the output of this auxiliary function for the bessel case.
}
\description{
Q-function related to the bessel model. This function is required in the Expectation-Maximization algorithm.
}
