% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor_functions.R
\name{extractor_functions}
\alias{extractor_functions}
\alias{extract_arguments}
\alias{extract_arguments.bgms}
\alias{extract_arguments.bgmCompare}
\alias{extract_indicators}
\alias{extract_indicators.bgms}
\alias{extract_indicators.bgmCompare}
\alias{extract_posterior_inclusion_probabilities}
\alias{extract_posterior_inclusion_probabilities.bgms}
\alias{extract_sbm}
\alias{extract_sbm.bgms}
\alias{extract_posterior_inclusion_probabilities.bgmCompare}
\alias{extract_indicator_priors}
\alias{extract_indicator_priors.bgms}
\alias{extract_indicator_priors.bgmCompare}
\alias{extract_pairwise_interactions}
\alias{extract_pairwise_interactions.bgms}
\alias{extract_pairwise_interactions.bgmCompare}
\alias{extract_category_thresholds}
\alias{extract_category_thresholds.bgms}
\alias{extract_category_thresholds.bgmCompare}
\alias{extract_group_params}
\alias{extract_group_params.bgmCompare}
\alias{extract_edge_indicators}
\alias{extract_pairwise_thresholds}
\title{Extractor Functions for bgms Objects}
\usage{
extract_arguments(bgms_object)

\method{extract_arguments}{bgms}(bgms_object)

\method{extract_arguments}{bgmCompare}(bgms_object)

extract_indicators(bgms_object)

\method{extract_indicators}{bgms}(bgms_object)

\method{extract_indicators}{bgmCompare}(bgms_object)

extract_posterior_inclusion_probabilities(bgms_object)

\method{extract_posterior_inclusion_probabilities}{bgms}(bgms_object)

extract_sbm(bgms_object)

\method{extract_sbm}{bgms}(bgms_object)

\method{extract_posterior_inclusion_probabilities}{bgmCompare}(bgms_object)

extract_indicator_priors(bgms_object)

\method{extract_indicator_priors}{bgms}(bgms_object)

\method{extract_indicator_priors}{bgmCompare}(bgms_object)

extract_pairwise_interactions(bgms_object)

\method{extract_pairwise_interactions}{bgms}(bgms_object)

\method{extract_pairwise_interactions}{bgmCompare}(bgms_object)

extract_category_thresholds(bgms_object)

\method{extract_category_thresholds}{bgms}(bgms_object)

\method{extract_category_thresholds}{bgmCompare}(bgms_object)

extract_group_params(bgms_object)

\method{extract_group_params}{bgmCompare}(bgms_object)

extract_edge_indicators(bgms_object)

extract_pairwise_thresholds(bgms_object)
}
\description{
Extractor Functions for bgms Objects
}
\details{
These functions extract various components from objects returned by the `bgm()` function,
such as edge indicators, posterior inclusion probabilities, and parameter summaries.

Internally, indicator samples were stored in `$gamma` (pre-0.1.4) and
`$indicator` (0.1.4–0.1.5). As of **bgms 0.1.6.0**, they are stored in
`$raw_samples$indicators`. Access via older names is supported but deprecated.

Posterior inclusion probabilities are computed from edge indicators.

Internally, indicator samples were stored in `$gamma` (pre-0.1.4) and
`$indicator` (0.1.4–0.1.5). As of **bgms 0.1.6.0**, they are stored in
`$raw_samples$indicator`. Access via older names is supported but deprecated.

Category thresholds were previously stored in `$main_effects` (pre-0.1.4) and
`$posterior_mean_main` (0.1.4–0.1.5). As of **bgms 0.1.6.0**, they are stored
in `$posterior_summary_main`. Access via older names is supported but deprecated.
}
\section{Functions}{

- `extract_arguments()` – Extract model arguments
- `extract_indicators()` – Get sampled edge indicators
- `extract_posterior_inclusion_probabilities()` – Posterior edge inclusion probabilities
- `extract_pairwise_interactions()` – Posterior mean of pairwise interactions
- `extract_category_thresholds()` – Posterior mean of category thresholds
- `extract_indicator_priors()` – Prior structure used for edge indicators
- `extract_sbm`  – Extract stochastic block model parameters (if applicable)
}

\keyword{internal}
