% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_suggest.R
\name{suggest_layout_from_previous}
\alias{suggest_layout_from_previous}
\title{Suggest layout based on previous stage content using heuristics}
\usage{
suggest_layout_from_previous(previous_stage, telemetry_flags = NULL)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage
function containing stage data with potential fields like problem,
evidence, central_question, data_story, etc.}

\item{telemetry_flags}{Optional named list of telemetry flags from bid_flags()
Used to adjust layout recommendations based on observed behavior patterns}
}
\value{
Character string indicating the suggested layout type
("breathable", "dual_process", "grid", "card", "tabs", or fallback)
}
\description{
Automatically suggests an appropriate layout type based on content analysis
of previous BID stages. Uses deterministic heuristics to match keywords in
problem descriptions, evidence, data story, and other contextual information
to layout types that best address the identified issues.
}
\details{
The heuristics follow a priority order:
\enumerate{
\item \strong{breathable} - if content suggests information overload, confusion, or
cognitive load issues
\item \strong{dual_process} - if content mentions overview vs detail, quick vs deep,
or two-mode interactions
\item \strong{grid} - if content focuses on grouping, clustering, visual hierarchy,
or comparing related metrics
\item \strong{card} - if content mentions cards, chunks, tiles, modular blocks,
or per-item summaries
\item \strong{tabs} - if content suggests sections, categories, progressive
disclosure, but avoids tabs if telemetry shows tab drop-off
\item \strong{breathable} - fallback for any unmatched cases
}
}
\keyword{internal}
