% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_qMap.R
\name{bdm.qMap}
\alias{bdm.qMap}
\title{ptSNE quantile-maps}
\usage{
bdm.qMap(bdm, data = NULL, labels = NULL, subset = NULL,
  qMap.levels = 8, qMap.cex = 0.3, qMap.bg = "#FFFFFF",
  class.pltt = NULL, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{data}{A \code{matrix/data.frame} to be mapped. By default, the input data \var{bdm$data} is mapped.}

\item{labels}{A vector of class labels of length equal to \code{nrow(bdm$data)}. Label values are factorized as \code{as.numeric(as.factor(labels))}. If \code{!is.null(bdm$lbls)}, these labels are used by default.}

\item{subset}{A numeric vector with the indexes of a subset of data. Data-points in the subset are heat-mapped and the rest are shown in light grey. By default all data-points are heat-mapped.}

\item{qMap.levels}{The number of levels of the quantile-map (8 by default).}

\item{qMap.cex}{The size of the data-points (as in \code{par()}).}

\item{qMap.bg}{The background colour of the qMap plot. Default value is \code{ptsne.bg = #FFFFFF} (white).}

\item{class.pltt}{If \code{!is.null(labels)} or \code{!is.null(bdm$lbls)}, a colour palette to show class labels with the qMap plots. By default (\code{qMap.pltt = NULL}) the default palette is used.}

\item{layer}{The number of a layer (1 by default).}
}
\value{
None.
}
\description{
Shows the mapping of quantitative variables into the embedding space.
}
\details{
This is not a heat-map but a quantile-map plot. This function splits the range of each variable into as many quantiles as specified by \var{levels} so that the color gradient will hardly ever correspond to a constant numeric gradient. Thus, the mapping will show more evenly distributed colors though at the expense of possibly exaggerating artifacts. For variables with very extrem distributions, it will be impossible to find as many quantiles as desired and the distribution of colors will not be so homogeneous.
}
\examples{

bdm.example()
bdm.qMap(exMap)
# --- show only components (1, 2, 4, 8) of the GMM
bdm.qMap(exMap, subset = which(exMap$lbls \%in\% c(1, 4, 8, 16)))
}
