% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SterrettFunctions.R
\name{pmf.Sterrett}
\alias{pmf.Sterrett}
\title{Extract probability mass function (PMF) from group testing results}
\usage{
\method{pmf}{Sterrett}(object, ...)
}
\arguments{
\item{object}{An object of class "Sterrett", created by
\code{\link{Sterrett}}, from which the PMF is to be extracted.}

\item{...}{currently not used.}
}
\value{
Data frame containing the probability mass function
extracted from the object \kbd{object}.
}
\description{
Extract the probability mass function from group testing results
for the Sterrett algorithm (objects of class "Sterrett" returned
by \code{\link{Sterrett}}).
}
\examples{
set.seed(1231)
p.vec <- rbeta(n = 8, shape1 = 1, shape2 = 10)
res <- Sterrett(p = p.vec, Sp = 0.90, Se = 0.95)
pmf(res)
}
\author{
Brianna D. Hitt
}
