% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{interpolate}
\alias{interpolate}
\title{Interpolation of new samples}
\usage{
interpolate(bp, newdata)
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{newdata}{a new data set, similar in structure to the data set supplied to \code{biplot()}
containing supplementary data points to be added on the biplot.}
}
\value{
Object of class PCA with the following elements:
\item{X}{matrix of the centered and scaled numeric variables.}
\item{Xcat}{matrix of the categorical variables.}
\item{raw.X}{original data.}
\item{na.action}{vector of observations that have been removed.}
\item{center}{TRUE or FALSE, whether X is centred.}
\item{scaled}{TRUE or FALSE, whether X is scaled.}
\item{means}{mean of each numerical variable.}
\item{sd}{standard deviation of each numerical variable.}
\item{n}{number of observations.}
\item{p}{number of variables.}
\item{group.aes}{vector of the same length as the number of rows in the data matrix for differentiated aesthetics for samples.}
\item{g.names}{descriptive name to be used for group labels.}
\item{g}{number of groups.}
\item{Title}{title of the biplot to be rendered}
\item{Z}{matrix with each row containing the details of the point to be plotted (i.e. coordinates).}
\item{Lmat}{matrix for transformation to the principal components.}
\item{e.vects}{vector indicating which principal components are plotted in the biplot.}
\item{ax.one.unit}{one unit in the positive direction of each biplot axis.}
\item{Xnew.raw}{ newdata numerical variables.}
\item{Xnew}{matrix of the centered and scaled new numeric variables.}
\item{Xnew.cat}{matrix of the new categorical variables.}
\item{Znew}{matrix of the coordinates of the newdata in the biplot.}
}
\description{
Interpolation of new samples
}
\examples{
biplot(data = iris[1:145,]) |> PCA() |> interpolate(newdata = iris[146:150,]) |> plot()

}
