% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{catmull_rom}
\alias{catmull_rom}
\title{Catmull-Rom Interpolation}
\usage{
catmull_rom(control_points, closed = FALSE, alpha = 0.5)
}
\arguments{
\item{control_points}{List of control points, where each element is a numeric vector of length 3.}

\item{closed}{Logical indicating whether the spline is closed (i.e., the first and last control points are connected), defaults to false}

\item{alpha}{Numeric scalar for the tension parameter, defaults to 0.5}
}
\value{
An object of class \code{catmull_rom} with methods:
\itemize{
\item \code{spline(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{max_parameter()}: Get the maximum parameter value of the spline.
\item \code{parameter_at_point(i)}: Get the parameter value at index \code{i}.
}
}
\description{
Constructs a Catmull-Rom spline interpolator given control points.
}
\examples{
control_points <- list(c(0, 0, 0), c(1, 1, 0), c(2, 0, 0), c(3, 1, 0))
interpolator <- catmull_rom(control_points)
xi <- 1.5
interpolator$spline(xi)
interpolator$prime(xi)
interpolator$max_parameter()
interpolator$parameter_at_point(2)
}
