% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YTplsR.R
\name{nbcomp.bootplsR}
\alias{nbcomp.bootplsR}
\title{Non-parametric (Y,T) Bootstrap for selecting the number of components in PLSR 
models}
\usage{
nbcomp.bootplsR(
  Y,
  X,
  R = 500,
  sim = "ordinary",
  ncpus = 1,
  parallel = "no",
  typeBCa = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{Y}{Vector of response.}

\item{X}{Matrix of predictors.}

\item{R}{The number of bootstrap replicates. Usually this will be a single
positive integer. For importance resampling, some resamples may use one set
of weights and others use a different set of weights. In this case \code{R}
would be a vector of integers where each component gives the number of
resamples from each of the rows of weights.}

\item{sim}{A character string indicating the type of simulation required.
Possible values are \code{"ordinary"} (the default), \code{"balanced"},
\code{"permutation"}, or \code{"antithetic"}.}

\item{ncpus}{integer: number of processes to be used in parallel operation: 
typically one would chose this to the number of available CPUs.}

\item{parallel}{The type of parallel operation to be used (if any). 
If missing, the default is taken from the option "boot.parallel" 
(and if that is not set, "no").}

\item{typeBCa}{Compute BCa type intervals ?}

\item{verbose}{Display info during the run of algorithm?}
}
\value{
A numeric, the number of components selected by the bootstrap.
}
\description{
Provides a wrapper for the bootstrap function \code{boot} from the
\code{boot} R package.\cr Implements non-parametric bootstraps for PLS
Regression models by (Y,T) resampling to select the number of components.
}
\details{
More details on bootstrap techniques are available in the help of the
\code{\link[boot:boot]{boot}} function.
}
\examples{
data(pine, package="plsRglm")
Xpine<-pine[,1:10]
ypine<-log(pine[,11])
res <- nbcomp.bootplsR(ypine, Xpine)
nbcomp.bootplsR(ypine, Xpine, typeBCa=FALSE)
\donttest{
nbcomp.bootplsR(ypine, Xpine, typeBCa=FALSE, verbose=FALSE)
try(nbcomp.bootplsR(ypine, Xpine, sim="permutation"))
nbcomp.bootplsR(ypine, Xpine, sim="permutation", typeBCa=FALSE)
}

}
\references{
A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Computing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
\doi{10.3389/fams.2021.693126}\cr.
}
\author{
Jérémy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
