% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.r
\name{throw}
\alias{throw}
\alias{rethrow}
\alias{rethrow_on_error}
\alias{box_error}
\title{Throw informative error messages}
\usage{
throw(..., call = sys.call(sys.parent()), subclass = NULL)

rethrow(error, call = sys.call(sys.parent()))

rethrow_on_error(expr, call = sys.call(sys.parent()))

box_error(message, call = NULL, subclass = NULL)
}
\arguments{
\item{\dots}{arguments to be passed to \code{fmt}}

\item{call}{the calling context from which the error is raised}

\item{subclass}{an optional subclass name for the error condition to be
raised}

\item{error}{an object of class \code{c("error", "condition")} to rethrow}

\item{expr}{an expression to evaluate inside \code{tryCatch}}

\item{message}{the error message}
}
\value{
If it does not throw an error, \code{rethrow_on_error} returns the
value of evaluating \code{expr}.

\code{box_error} returns a new \sQuote{box} error condition object
with a given message and call, and optionally a given subclass type.
}
\description{
Helpers to generate readable and informative error messages for package
users.
}
\details{
For \code{rethrow}, the \code{call} argument overrides the rethrown error’s
own stored call.
}
\keyword{internal}
