% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break.R
\name{broken.lm}
\alias{broken.lm}
\title{Create the broken object for lm models}
\usage{
\method{broken}{lm}(model, new_observation, ..., baseline = 0)
}
\arguments{
\item{model}{a lm model}

\item{new_observation}{a new observation with collumns that corresponds to variables used in the model}

\item{...}{other parameters}

\item{baseline}{the orgin/baseline for the breakDown plots, where the rectangles start. It may be a number or a character "Intercept". In the latter case the orgin will be set to model intercept.}
}
\value{
an object of the broken class
}
\description{
Create the broken object for lm models
}
\examples{
model <- lm(Sepal.Length~., data=iris)
new_observation <- iris[1,]
br <- broken(model, new_observation)
plot(br)

# works for interactions as well
model <- lm(Sepal.Length ~ Petal.Width*Species, data = iris)
new_observation <- iris[1,]
br <- broken(model, new_observation)
plot(br)
}
